/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.LoaderVersion;
import net.fabricmc.installer.Main;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.Utils;

public abstract class Handler
implements InstallerProgress {
    protected static final int HORIZONTAL_SPACING = 4;
    protected static final int VERTICAL_SPACING = 6;
    private static final String SELECT_CUSTOM_ITEM = "(select custom)";
    public JButton buttonInstall;
    public JComboBox<String> gameVersionComboBox;
    private JComboBox<String> loaderVersionComboBox;
    public JTextField installLocation;
    public JButton selectFolderButton;
    public JLabel statusLabel;
    public JCheckBox snapshotCheckBox;
    private JPanel pane;

    public abstract String name();

    public abstract void install();

    public abstract void installCli(ArgumentParser var1) throws Exception;

    public abstract String cliHelp();

    public void setupPane1(JPanel pane, GridBagConstraints c, InstallerGui installerGui) {
    }

    public void setupPane2(JPanel pane, GridBagConstraints c, InstallerGui installerGui) {
    }

    public JPanel makePanel(InstallerGui installerGui) {
        this.pane = new JPanel(new GridBagLayout());
        this.pane.setBorder(new EmptyBorder(4, 4, 4, 4));
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(6, 4, 6, 4);
        c.gridy = 0;
        c.gridx = 0;
        this.setupPane1(this.pane, c, installerGui);
        Component[] componentArray = new Component[3];
        this.gameVersionComboBox = new JComboBox();
        componentArray[0] = this.gameVersionComboBox;
        componentArray[1] = Handler.createSpacer();
        this.snapshotCheckBox = new JCheckBox(Utils.BUNDLE.getString("option.show.snapshots"));
        componentArray[2] = this.snapshotCheckBox;
        this.addRow((Container)this.pane, c, "prompt.game.version", componentArray);
        this.snapshotCheckBox.setSelected(false);
        this.snapshotCheckBox.addActionListener(e -> {
            if (Main.GAME_VERSION_META.isComplete()) {
                this.updateGameVersions();
            }
        });
        Main.GAME_VERSION_META.onComplete(versions -> this.updateGameVersions());
        Component[] componentArray2 = new Component[1];
        this.loaderVersionComboBox = new JComboBox();
        componentArray2[0] = this.loaderVersionComboBox;
        this.addRow((Container)this.pane, c, "prompt.loader.version", componentArray2);
        Component[] componentArray3 = new Component[2];
        this.installLocation = new JTextField(20);
        componentArray3[0] = this.installLocation;
        this.selectFolderButton = new JButton();
        componentArray3[1] = this.selectFolderButton;
        this.addRow((Container)this.pane, c, "prompt.select.location", componentArray3);
        this.selectFolderButton.setText("...");
        this.selectFolderButton.setPreferredSize(new Dimension(this.installLocation.getPreferredSize().height, this.installLocation.getPreferredSize().height));
        this.selectFolderButton.addActionListener(e -> InstallerGui.selectInstallLocation(() -> this.installLocation.getText(), s -> this.installLocation.setText((String)s)));
        this.setupPane2(this.pane, c, installerGui);
        Component[] componentArray4 = new Component[1];
        this.statusLabel = new JLabel();
        componentArray4[0] = this.statusLabel;
        this.addRow((Container)this.pane, c, null, componentArray4);
        this.statusLabel.setText(Utils.BUNDLE.getString("prompt.loading.versions"));
        Component[] componentArray5 = new Component[1];
        this.buttonInstall = new JButton(Utils.BUNDLE.getString("prompt.install"));
        componentArray5[0] = this.buttonInstall;
        this.addLastRow(this.pane, c, null, componentArray5);
        this.buttonInstall.addActionListener(e -> {
            this.buttonInstall.setEnabled(false);
            this.install();
        });
        Main.LOADER_META.onComplete(versions -> {
            int stableIndex = -1;
            for (int i = 0; i < versions.size(); ++i) {
                MetaHandler.GameVersion version = (MetaHandler.GameVersion)versions.get(i);
                this.loaderVersionComboBox.addItem(version.getVersion());
                if (!version.isStable()) continue;
                stableIndex = i;
            }
            this.loaderVersionComboBox.addItem(SELECT_CUSTOM_ITEM);
            if (stableIndex == -1) {
                stableIndex = 0;
            }
            this.loaderVersionComboBox.setSelectedIndex(stableIndex);
            this.statusLabel.setText(Utils.BUNDLE.getString("prompt.ready.install"));
        });
        return this.pane;
    }

    private void updateGameVersions() {
        this.gameVersionComboBox.removeAllItems();
        for (MetaHandler.GameVersion version : Main.GAME_VERSION_META.getVersions()) {
            if (!this.snapshotCheckBox.isSelected() && !version.isStable()) continue;
            this.gameVersionComboBox.addItem(version.getVersion());
        }
        this.gameVersionComboBox.setSelectedIndex(0);
        InstallerGui.instance.updateSize(false);
    }

    protected LoaderVersion queryLoaderVersion() {
        String ret = (String)this.loaderVersionComboBox.getSelectedItem();
        if (!ret.equals(SELECT_CUSTOM_ITEM)) {
            return new LoaderVersion(ret);
        }
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle("Select Fabric Loader JAR");
        chooser.setFileFilter(new FileNameExtensionFilter("Java Archive", "jar"));
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(null) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        try {
            return new LoaderVersion(file.toPath());
        }
        catch (IOException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void updateProgress(String text) {
        this.statusLabel.setText(text);
        this.statusLabel.setForeground(UIManager.getColor("Label.foreground"));
    }

    protected String buildEditorPaneStyle() {
        JLabel label = new JLabel();
        Font font = label.getFont();
        Color color = label.getBackground();
        return String.format(Locale.ENGLISH, "font-family:%s;font-weight:%s;font-size:%dpt;background-color: rgb(%d,%d,%d);", font.getFamily(), font.isBold() ? "bold" : "normal", font.getSize(), color.getRed(), color.getGreen(), color.getBlue());
    }

    @Override
    public void error(Throwable throwable) {
        StringWriter sw = new StringWriter(800);
        try (PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
        }
        String st = sw.toString().trim();
        System.err.println(st);
        String html = String.format("<html><body style=\"%s\">%s</body></html>", this.buildEditorPaneStyle(), st.replace(System.lineSeparator(), "<br>").replace("\t", "&ensp;"));
        JEditorPane textPane = new JEditorPane("text/html", html);
        textPane.setEditable(false);
        this.statusLabel.setText(throwable.getLocalizedMessage());
        this.statusLabel.setForeground(Color.RED);
        JOptionPane.showMessageDialog(this.pane, textPane, Utils.BUNDLE.getString("prompt.exception.occurrence"), 0);
    }

    protected void addRow(Container parent, GridBagConstraints c, String label, Component ... components) {
        this.addRow(parent, c, false, label, components);
    }

    protected void addLastRow(Container parent, GridBagConstraints c, String label, Component ... components) {
        this.addRow(parent, c, true, label, components);
    }

    protected static Component createSpacer() {
        return Box.createRigidArea(new Dimension(4, 0));
    }

    private void addRow(Container parent, GridBagConstraints c, boolean last, String label, Component ... components) {
        if (label != null) {
            c.gridwidth = 1;
            c.anchor = 22;
            c.fill = 0;
            c.weightx = 0.0;
            parent.add((Component)new JLabel(Utils.BUNDLE.getString(label)), c);
            ++c.gridx;
            c.anchor = 21;
            c.fill = 2;
        } else {
            c.gridwidth = 2;
            if (last) {
                c.weighty = 1.0;
            }
            c.anchor = last ? 19 : 10;
            c.fill = 0;
        }
        c.weightx = 1.0;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        for (Component comp : components) {
            panel.add(comp);
        }
        parent.add((Component)panel, c);
        ++c.gridy;
        c.gridx = 0;
    }

    protected String getGameVersion(ArgumentParser args) {
        return Handler.getVersion(args.get("mcversion"), args.has("snapshot"), Main.GAME_VERSION_META);
    }

    protected String getLoaderVersion(ArgumentParser args) {
        return Handler.getVersion(args.get("loader"), false, Main.LOADER_META);
    }

    private static String getVersion(String name, boolean snapshot, MetaHandler meta) {
        MetaHandler.GameVersion ret = meta.parseVersion(name, snapshot);
        if (ret == null) {
            throw new IllegalArgumentException(String.format("unknown %s version: %s", meta.getName(), name));
        }
        return ret.getVersion();
    }
}

