/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.installer.util.OperatingSystem;

public class Utils {
    public static final DateFormat ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    public static final ResourceBundle BUNDLE = ResourceBundle.getBundle("lang/installer", Locale.getDefault(), new ResourceBundle.Control(){

        @Override
        public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
            block11: {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, "properties").toLowerCase(Locale.ROOT);
                try (InputStream stream = loader.getResourceAsStream(resourceName);){
                    PropertyResourceBundle propertyResourceBundle;
                    if (stream == null) break block11;
                    try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                        propertyResourceBundle = new PropertyResourceBundle(reader);
                    }
                    return propertyResourceBundle;
                }
            }
            return super.newBundle(baseName, locale, format, loader, reload);
        }
    });
    private static final int HTTP_TIMEOUT_MS = 8000;

    public static Path findDefaultInstallDir() {
        Path dir;
        if (OperatingSystem.CURRENT == OperatingSystem.WINDOWS && System.getenv("APPDATA") != null) {
            dir = Paths.get(System.getenv("APPDATA"), new String[0]).resolve(".minecraft");
        } else {
            String home = System.getProperty("user.home", ".");
            Path homeDir = Paths.get(home, new String[0]);
            if (OperatingSystem.CURRENT == OperatingSystem.MACOS) {
                dir = homeDir.resolve("Library").resolve("Application Support").resolve("minecraft");
            } else {
                Path flatpack;
                dir = homeDir.resolve(".minecraft");
                if (OperatingSystem.CURRENT == OperatingSystem.LINUX && !Files.exists(dir, new LinkOption[0]) && Files.exists(flatpack = homeDir.resolve(".var").resolve("app").resolve("com.mojang.Minecraft").resolve(".minecraft"), new LinkOption[0])) {
                    dir = flatpack;
                }
            }
        }
        return dir.toAbsolutePath().normalize();
    }

    public static String readString(URL url) throws IOException {
        try (InputStream is = Utils.openUrl(url);){
            String string = Utils.readString(is);
            return string;
        }
    }

    public static String readString(Path path) throws IOException {
        return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
    }

    public static String readString(InputStream is) throws IOException {
        int len;
        byte[] data = new byte[Math.max(1000, is.available())];
        int offset = 0;
        while ((len = is.read(data, offset, data.length - offset)) >= 0) {
            if ((offset += len) != data.length) continue;
            int next = is.read();
            if (next < 0) break;
            data = Arrays.copyOf(data, data.length * 2);
            data[offset++] = (byte)next;
        }
        return new String(data, 0, offset, StandardCharsets.UTF_8);
    }

    public static void writeToFile(Path path, String string) throws IOException {
        Files.write(path, string.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static void downloadFile(URL url, Path path) throws IOException {
        try (InputStream in = Utils.openUrl(url);){
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(path);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    private static InputStream openUrl(URL url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setConnectTimeout(8000);
        conn.setReadTimeout(8000);
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            throw new IOException("HTTP request to " + url + " failed: " + responseCode);
        }
        return conn.getInputStream();
    }

    public static String getProfileIcon() {
        String string;
        block9: {
            InputStream is = Utils.class.getClassLoader().getResourceAsStream("profile_icon.png");
            try {
                int len;
                byte[] ret = new byte[4096];
                int offset = 0;
                while ((len = is.read(ret, offset, ret.length - offset)) != -1) {
                    if ((offset += len) != ret.length) continue;
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                string = "data:image/png;base64," + Base64.getEncoder().encodeToString(Arrays.copyOf(ret, offset));
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return "TNT";
                }
            }
            is.close();
        }
        return string;
    }

    public static String sha1String(Path path) throws IOException {
        return Utils.bytesToHex(Utils.sha1(path));
    }

    public static byte[] sha1(Path path) throws IOException {
        MessageDigest digest = Utils.sha1Digest();
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            int len;
            byte[] buffer = new byte[65536];
            while ((len = is.read(buffer)) >= 0) {
                digest.update(buffer, 0, len);
            }
        }
        return digest.digest();
    }

    private static MessageDigest sha1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Something has gone really wrong", e);
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuilder output = new StringBuilder();
        for (byte b : bytes) {
            output.append(String.format(Locale.ENGLISH, "%02x", b));
        }
        return output.toString();
    }

    public static int compareVersions(String versionA, String versionB) {
        boolean bHasPreRelease;
        Pattern pattern = Pattern.compile("(\\d+(?:\\.\\d+)*)(?:-([^+]+))?(?:\\+.*)?");
        Matcher matcherA = pattern.matcher(versionA);
        Matcher matcherB = pattern.matcher(versionB);
        if (!matcherA.matches() || !matcherB.matches()) {
            return versionA.compareTo(versionB);
        }
        int cmp = Utils.compareVersionGroups(matcherA.group(1), matcherB.group(1));
        if (cmp != 0) {
            return cmp;
        }
        boolean aHasPreRelease = matcherA.group(2) != null;
        boolean bl = bHasPreRelease = matcherB.group(2) != null;
        if (aHasPreRelease != bHasPreRelease) {
            return aHasPreRelease ? -1 : 1;
        }
        if (aHasPreRelease && (cmp = Utils.compareVersionGroups(matcherA.group(2), matcherB.group(2))) != 0) {
            return cmp;
        }
        return 0;
    }

    private static int compareVersionGroups(String groupA, String groupB) {
        String[] partsA = groupA.split("\\.");
        String[] partsB = groupB.split("\\.");
        for (int i = 0; i < Math.min(partsA.length, partsB.length); ++i) {
            String partA = partsA[i];
            String partB = partsB[i];
            try {
                int a = Integer.parseInt(partA);
                try {
                    int b = Integer.parseInt(partB);
                    int cmp = Integer.compare(a, b);
                    if (cmp != 0) {
                        return cmp;
                    }
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            catch (NumberFormatException e) {
                try {
                    Integer.parseInt(partB);
                    return 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int cmp = partA.compareTo(partB);
            if (cmp == 0) continue;
            return cmp;
        }
        return Integer.compare(partsA.length, partsB.length);
    }
}

