/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.server;

import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.fabricmc.installer.Handler;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.LoaderVersion;
import net.fabricmc.installer.server.MinecraftServerDownloader;
import net.fabricmc.installer.server.ServerInstaller;
import net.fabricmc.installer.server.ServerPostInstallDialog;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;

public class ServerHandler
extends Handler {
    @Override
    public String name() {
        return "Server";
    }

    @Override
    public void install() {
        String gameVersion = (String)this.gameVersionComboBox.getSelectedItem();
        LoaderVersion loaderVersion = this.queryLoaderVersion();
        if (loaderVersion == null) {
            return;
        }
        new Thread(() -> {
            try {
                ServerInstaller.install(Paths.get(this.installLocation.getText(), new String[0]).toAbsolutePath(), loaderVersion, gameVersion, this);
                ServerPostInstallDialog.show(this);
            }
            catch (Exception e) {
                this.error(e);
            }
            this.buttonInstall.setEnabled(true);
        }).start();
    }

    @Override
    public void installCli(ArgumentParser args) throws Exception {
        Path dir = Paths.get(args.getOrDefault("dir", () -> "."), new String[0]).toAbsolutePath().normalize();
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new FileNotFoundException("Server directory not found at " + dir + " or not a directory");
        }
        LoaderVersion loaderVersion = new LoaderVersion(this.getLoaderVersion(args));
        String gameVersion = this.getGameVersion(args);
        ServerInstaller.install(dir, loaderVersion, gameVersion, InstallerProgress.CONSOLE);
        if (args.has("downloadMinecraft")) {
            InstallerProgress.CONSOLE.updateProgress(Utils.BUNDLE.getString("progress.download.minecraft"));
            Path serverJar = dir.resolve("server.jar");
            MinecraftServerDownloader downloader = new MinecraftServerDownloader(gameVersion);
            downloader.downloadMinecraftServer(serverJar);
            InstallerProgress.CONSOLE.updateProgress(Utils.BUNDLE.getString("progress.done"));
        }
        InstallerProgress.CONSOLE.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.done.start.server")).format(new Object[]{"fabric-server-launch.jar"}));
    }

    @Override
    public String cliHelp() {
        return "-dir <install dir, default current dir> -mcversion <minecraft version, default latest> -loader <loader version, default latest> -downloadMinecraft";
    }

    @Override
    public void setupPane1(JPanel pane, GridBagConstraints c, InstallerGui installerGui) {
        if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            return;
        }
        JLabel label = new JLabel(String.format("<html><a href=\"\">%s</a></html>", Utils.BUNDLE.getString("prompt.server.launcher")));
        label.setCursor(new Cursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(Reference.serverLauncherUrl));
                }
                catch (IOException | URISyntaxException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.addRow(pane, c, null, label);
    }

    @Override
    public void setupPane2(JPanel pane, GridBagConstraints c, InstallerGui installerGui) {
        this.installLocation.setText(Paths.get(".", new String[0]).toAbsolutePath().normalize().toString());
    }
}

