/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.client;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import net.fabricmc.installer.Handler;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.LoaderVersion;
import net.fabricmc.installer.client.ClientInstaller;
import net.fabricmc.installer.client.ProfileInstaller;
import net.fabricmc.installer.launcher.MojangLauncherHelperWrapper;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.InstallerProgress;
import net.fabricmc.installer.util.Reference;
import net.fabricmc.installer.util.Utils;

public class ClientHandler
extends Handler {
    private JCheckBox createProfile;

    @Override
    public String name() {
        return "Client";
    }

    @Override
    public void install() {
        if (MojangLauncherHelperWrapper.isMojangLauncherOpen()) {
            this.showLauncherOpenMessage();
            return;
        }
        this.doInstall();
    }

    private void doInstall() {
        String gameVersion = (String)this.gameVersionComboBox.getSelectedItem();
        LoaderVersion loaderVersion = this.queryLoaderVersion();
        if (loaderVersion == null) {
            return;
        }
        System.out.println("Installing");
        new Thread(() -> {
            try {
                this.updateProgress(new MessageFormat(Utils.BUNDLE.getString("progress.installing")).format(new Object[]{loaderVersion.name}));
                Path mcPath = Paths.get(this.installLocation.getText(), new String[0]);
                if (!Files.exists(mcPath, new LinkOption[0])) {
                    throw new RuntimeException(Utils.BUNDLE.getString("progress.exception.no.launcher.directory"));
                }
                ProfileInstaller profileInstaller = new ProfileInstaller(mcPath);
                ProfileInstaller.LauncherType launcherType = null;
                if (this.createProfile.isSelected()) {
                    List<ProfileInstaller.LauncherType> types = profileInstaller.getInstalledLauncherTypes();
                    if (types.size() == 0) {
                        throw new RuntimeException(Utils.BUNDLE.getString("progress.exception.no.launcher.profile"));
                    }
                    if (types.size() == 1) {
                        launcherType = types.get(0);
                    } else {
                        launcherType = this.showLauncherTypeSelection();
                        if (launcherType == null) {
                            this.statusLabel.setText(Utils.BUNDLE.getString("prompt.ready.install"));
                            return;
                        }
                    }
                }
                String profileName = ClientInstaller.install(mcPath, gameVersion, loaderVersion, this);
                if (this.createProfile.isSelected()) {
                    if (launcherType == null) {
                        throw new RuntimeException(Utils.BUNDLE.getString("progress.exception.no.launcher.profile"));
                    }
                    profileInstaller.setupProfile(profileName, gameVersion, launcherType);
                }
                SwingUtilities.invokeLater(() -> this.showInstalledMessage(loaderVersion.name, gameVersion));
            }
            catch (Exception e) {
                this.error(e);
            }
            finally {
                this.buttonInstall.setEnabled(true);
            }
        }).start();
    }

    private void showInstalledMessage(String loaderVersion, String gameVersion) {
        JEditorPane pane = new JEditorPane("text/html", "<html><body style=\"" + this.buildEditorPaneStyle() + "\">" + new MessageFormat(Utils.BUNDLE.getString("prompt.install.successful")).format(new Object[]{loaderVersion, gameVersion, Reference.fabricApiUrl}) + "</body></html>");
        pane.setEditable(false);
        pane.addHyperlinkListener(e -> {
            block3: {
                try {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) break block3;
                    if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                        break block3;
                    }
                    throw new UnsupportedOperationException("Failed to open " + e.getURL().toString());
                }
                catch (Throwable throwable) {
                    this.error(throwable);
                }
            }
        });
        JOptionPane.showMessageDialog(null, pane, Utils.BUNDLE.getString("prompt.install.successful.title"), 1);
    }

    private ProfileInstaller.LauncherType showLauncherTypeSelection() {
        Object[] options = new Object[]{Utils.BUNDLE.getString("prompt.launcher.type.xbox"), Utils.BUNDLE.getString("prompt.launcher.type.win32")};
        int result = JOptionPane.showOptionDialog(null, Utils.BUNDLE.getString("prompt.launcher.type.body"), Utils.BUNDLE.getString("installer.title"), 1, 3, null, options, options[0]);
        if (result == -1) {
            return null;
        }
        return result == 0 ? ProfileInstaller.LauncherType.MICROSOFT_STORE : ProfileInstaller.LauncherType.WIN32;
    }

    private void showLauncherOpenMessage() {
        int result = JOptionPane.showConfirmDialog(null, Utils.BUNDLE.getString("prompt.launcher.open.body"), Utils.BUNDLE.getString("prompt.launcher.open.tile"), 0);
        if (result == 0) {
            this.doInstall();
        } else {
            this.buttonInstall.setEnabled(true);
        }
    }

    @Override
    public void installCli(ArgumentParser args) throws Exception {
        Path path = Paths.get(args.getOrDefault("dir", () -> Utils.findDefaultInstallDir().toString()), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("Launcher directory not found at " + path);
        }
        String gameVersion = this.getGameVersion(args);
        LoaderVersion loaderVersion = new LoaderVersion(this.getLoaderVersion(args));
        String profileName = ClientInstaller.install(path, gameVersion, loaderVersion, InstallerProgress.CONSOLE);
        if (args.has("noprofile")) {
            return;
        }
        ProfileInstaller profileInstaller = new ProfileInstaller(path);
        List<ProfileInstaller.LauncherType> types = profileInstaller.getInstalledLauncherTypes();
        ProfileInstaller.LauncherType launcherType = null;
        if (args.has("launcher")) {
            launcherType = ProfileInstaller.LauncherType.valueOf(args.get("launcher").toUpperCase(Locale.ROOT));
        }
        if (launcherType == null) {
            if (types.size() == 0) {
                throw new FileNotFoundException("Could not find a valid launcher profile .json");
            }
            if (types.size() == 1) {
                launcherType = types.get(0);
            } else {
                throw new FileNotFoundException("Multiple launcher installations were found, please specify the target launcher using -launcher");
            }
        }
        profileInstaller.setupProfile(profileName, gameVersion, launcherType);
    }

    @Override
    public String cliHelp() {
        return "-dir <install dir> -mcversion <minecraft version, default latest> -loader <loader version, default latest> -launcher [win32, microsoft_store]";
    }

    @Override
    public void setupPane2(JPanel pane, GridBagConstraints c, InstallerGui installerGui) {
        Component[] componentArray = new Component[1];
        this.createProfile = new JCheckBox(Utils.BUNDLE.getString("option.create.profile"), true);
        componentArray[0] = this.createProfile;
        this.addRow(pane, c, null, componentArray);
        this.installLocation.setText(Utils.findDefaultInstallDir().toString());
    }
}

