/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer;

import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.installer.Handler;
import net.fabricmc.installer.InstallerGui;
import net.fabricmc.installer.client.ClientHandler;
import net.fabricmc.installer.server.ServerHandler;
import net.fabricmc.installer.util.ArgumentParser;
import net.fabricmc.installer.util.CrashDialog;
import net.fabricmc.installer.util.MetaHandler;
import net.fabricmc.installer.util.OperatingSystem;
import net.fabricmc.installer.util.Reference;

public class Main {
    public static MetaHandler GAME_VERSION_META;
    public static MetaHandler LOADER_META;
    public static final List<Handler> HANDLERS;

    public static void main(String[] args) throws IOException {
        if (OperatingSystem.CURRENT == OperatingSystem.WINDOWS) {
            System.setProperty("javax.net.ssl.trustStoreType", "WINDOWS-ROOT");
        }
        System.out.println("Loading Fabric Installer: " + Main.class.getPackage().getImplementationVersion());
        HANDLERS.add(new ClientHandler());
        HANDLERS.add(new ServerHandler());
        ArgumentParser argumentParser = ArgumentParser.create(args);
        String command = argumentParser.getCommand().orElse(null);
        argumentParser.ifPresent("metaurl", s -> {
            Reference.metaServerUrl = s;
        });
        GAME_VERSION_META = new MetaHandler(Reference.getMetaServerEndpoint("v2/versions/game"));
        LOADER_META = new MetaHandler(Reference.getMetaServerEndpoint("v2/versions/loader"));
        if (GraphicsEnvironment.isHeadless() && command == null) {
            command = "help";
        }
        if (command == null) {
            try {
                InstallerGui.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                new CrashDialog(e);
            }
        } else if (command.equals("help")) {
            System.out.println("help - Opens this menu");
            HANDLERS.forEach(handler -> System.out.printf("%s %s\n", handler.name().toLowerCase(), handler.cliHelp()));
            LOADER_META.load();
            GAME_VERSION_META.load();
            System.out.printf("\nLatest Version: %s\nLatest Loader: %s\n", GAME_VERSION_META.getLatestVersion(argumentParser.has("snapshot")).getVersion(), LOADER_META.getLatestVersion(false).getVersion());
        } else {
            for (Handler handler2 : HANDLERS) {
                if (!command.equalsIgnoreCase(handler2.name())) continue;
                try {
                    handler2.installCli(argumentParser);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to install " + handler2.name(), e);
                }
                return;
            }
            System.out.println("No handler found for " + args[0] + " see help");
        }
    }

    static {
        HANDLERS = new ArrayList<Handler>();
    }
}

