/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.installer.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.installer.util.Utils;

public final class HttpClient {
    private static volatile Proxy lastSuccessfulProxy;
    private static final List<ProxySupplier> PROXIES;
    private static final int HTTP_TIMEOUT_MS = 8000;

    private HttpClient() {
    }

    public static String readString(URL url) throws IOException {
        return HttpClient.tryWithProxies(url, Utils::readString);
    }

    public static void downloadFile(URL url, Path path) throws IOException {
        try {
            HttpClient.tryWithProxies(url, in -> {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
                return null;
            });
        }
        catch (Throwable t) {
            try {
                Files.deleteIfExists(path);
            }
            catch (Throwable t2) {
                t.addSuppressed(t2);
            }
            throw t;
        }
    }

    private static InputStream openUrl(URL url, Proxy proxy) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)url.openConnection(proxy);
        conn.setConnectTimeout(8000);
        conn.setReadTimeout(8000);
        conn.connect();
        int responseCode = conn.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            throw new IOException("HTTP request to " + url + " failed: " + responseCode);
        }
        return conn.getInputStream();
    }

    private static List<Proxy> getEnvironmentProxies(URI uri) {
        String httpsProxy;
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        String httpProxy = System.getenv("HTTP_PROXY");
        if (httpProxy == null) {
            httpProxy = System.getenv("http_proxy");
        }
        if (httpProxy != null) {
            try {
                proxies.add(HttpClient.parseProxy(httpProxy));
            }
            catch (URISyntaxException e) {
                System.err.println("Invalid HTTP_PROXY environment variable: " + httpProxy);
            }
        }
        if ((httpsProxy = System.getenv("HTTPS_PROXY")) != null) {
            try {
                proxies.add(HttpClient.parseProxy(httpsProxy));
            }
            catch (URISyntaxException e) {
                System.err.println("Invalid HTTPS_PROXY environment variable: " + httpsProxy);
            }
        }
        return proxies;
    }

    private static Proxy parseProxy(String str) throws URISyntaxException {
        URI uri = new URI(str);
        String host = uri.getHost();
        int port = uri.getPort() == -1 ? 80 : uri.getPort();
        return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T tryWithProxies(URL url, Handler<T> handler) throws IOException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw new IOException(e.getMessage(), e);
        }
        HashSet<Proxy> attemptedProxies = new HashSet<Proxy>();
        IOException exception = null;
        if (lastSuccessfulProxy != null) {
            attemptedProxies.add(lastSuccessfulProxy);
            try (InputStream is = HttpClient.openUrl(url, lastSuccessfulProxy);){
                T t = handler.read(is);
                return t;
            }
            catch (IOException e) {
                lastSuccessfulProxy = null;
                exception = new IOException(String.format("Request to %s failed: %s", uri, e.getMessage()), e);
            }
        }
        Iterator<ProxySupplier> iterator = PROXIES.iterator();
        block16: while (true) {
            if (!iterator.hasNext()) {
                if (exception == null) throw new IllegalStateException("Did not attempt http connection");
                throw exception;
            }
            ProxySupplier proxySupplier = iterator.next();
            List<Proxy> proxies = proxySupplier.getProxies(uri);
            Iterator<Proxy> iterator2 = proxies.iterator();
            while (true) {
                if (!iterator2.hasNext()) continue block16;
                Proxy proxy = iterator2.next();
                if (proxy == null || !attemptedProxies.add(proxy)) continue;
                try {
                    T value;
                    try (InputStream is = HttpClient.openUrl(url, proxy);){
                        value = handler.read(is);
                    }
                    lastSuccessfulProxy = proxy;
                    return value;
                }
                catch (IOException e) {
                    IOException ioe = new IOException(String.format("Request to %s using %s failed: %s", uri, proxy, e.getMessage()), e);
                    if (exception == null) {
                        exception = ioe;
                        continue;
                    }
                    exception.addSuppressed(ioe);
                    continue;
                }
                break;
            }
            break;
        }
    }

    static {
        PROXIES = Arrays.asList(uri -> Collections.singletonList(Proxy.NO_PROXY), uri -> ProxySelector.getDefault().select(uri), HttpClient::getEnvironmentProxies);
    }

    private static interface Handler<T> {
        public T read(InputStream var1) throws IOException;
    }

    private static interface ProxySupplier {
        public List<Proxy> getProxies(URI var1) throws IOException;
    }
}

